
    
    <div class="row mb-5">
        
        <div class="col-xl-3 col-md-6">
           
            <div class="card card-stats">
    
                <div class="card-body">
                    <div class="row">
                        <div class="col">
                            <h5 class="card-title text-uppercase text-muted mb-0"><?php echo e(__('Template')); ?></h5>
                            <span class="h2 font-weight-bold mb-0"><?php echo e($item->template->name); ?></span>
                        </div>
                        <div class="col-auto">
                            <div class="icon icon-shape bg-gradient-info text-white rounded-circle shadow">
                                <i class="ni ni-notification-70"></i>
                            </div>
                        </div>
    
                    </div>
                    <p class="mt-3 mb-0 text-sm">
                        <?php if($item->timestamp_for_delivery > now()): ?>
                            <span class="text mr-2"><?php echo e(__('Scheduled for')); ?>: <?php echo e(date($item->timestamp_for_delivery)); ?></span> 
                        <?php else: ?>
                            <span class="text-v mr-2"><?php echo e($item->timestamp_for_delivery?$item->timestamp_for_delivery:$item->created_at); ?></span>
                        <?php endif; ?>
                       
                    </p>
                </div>
            </div>
        </div>

        <?php if($item->is_bot): ?>
        <?php elseif($item->is_api): ?>
            
        <?php else: ?>
            <div class="col-xl-3 col-md-6">
                <div class="card card-stats">
        
                    <div class="card-body">
                        <div class="row">
                            <div class="col">
                                <h5 class="card-title text-uppercase text-muted mb-0"><?php echo e(__('Contacts')); ?></h5>
                                <span class="h2 font-weight-bold mb-0"><?php echo e($item->send_to); ?></span>
                            </div>
                            <div class="col-auto">
                                <div class="icon icon-shape bg-gradient-info text-white rounded-circle shadow">
                                    <i class="ni ni-single-02"></i>
                                </div>
                            </div>
        
                        </div>
                        <p class="mt-3 mb-0 text-sm">
                            <span class="text mr-2">
                                <?php echo e(round(($item->send_to/$total_contacts)*100,2)); ?>% <?php echo e(__('of your contacts')); ?></span>
                        </p>
                    </div>
                </div>

            

            </div>
            <div class="col-xl-3 col-md-6">
                <div class="card card-stats">
        
                    <div class="card-body">
                        <div class="row">
                            <div class="col">
                                <h5 class="card-title text-uppercase text-muted mb-0"><?php echo e(__('Delivered to')); ?></h5>
                                <?php if($item->send_to > 0): ?>
                                    <span class="h2 font-weight-bold mb-0"><?php echo e(round(($item->delivered_to/$item->send_to)*100,2)); ?>%</span>
                                <?php else: ?>
                                    <span class="h2 font-weight-bold mb-0">0%</span>
                                <?php endif; ?>
                            </div>
                            <div class="col-auto">
                                <div class="icon icon-shape bg-gradient-info text-white rounded-circle shadow">
                                    <i class="ni ni-check-bold"></i>
                                </div>
                            </div>
        
                        </div>
                        <p class="mt-3 mb-0 text-sm">
                            <span class="text-success mr-2"><?php echo e($item->delivered_to); ?></span>
                            <span class="text-nowrap"><?php echo e(__('Contacts')); ?></span>
                        </p>
                    </div>
                </div>
            </div>
            <div class="col-xl-3 col-md-6">
                <div class="card card-stats">
        
                    <div class="card-body">
                        <div class="row">
                            <div class="col">
                                <h5 class="card-title text-uppercase text-muted mb-0"><?php echo e(__('Read by')); ?>

                                </h5>
                                <?php if($item->delivered_to>0): ?>
                                    <span class="h2 font-weight-bold mb-0"><?php echo e(round(($item->read_by/$item->delivered_to)*100,2)); ?>%</span>
                                <?php else: ?>
                                <span class="h2 font-weight-bold mb-0">0%</span>
                                <?php endif; ?>
                            
                            </div>
                            <div class="col-auto">
                                <div class="icon icon-shape bg-gradient-green text-white rounded-circle shadow">
                                    <i class="ni ni-chat-round"></i>
                                </div>
                            </div>
        
                        </div>
                        <p class="mt-3 mb-0 text-sm">
                            <span class="text mr-2">
                                <?php echo e($item->read_by); ?> <?php echo e(__('of the')); ?> <?php echo e($item->delivered_to); ?> <?php echo e(__('Contacts messaged.')); ?></span>
                            
                        </p>
                    </div>
                </div>
            </div> 
        <?php endif; ?>
       
    </div>
    
<?php /**PATH /home/aspailtd/public_html/wp.aspai.ltd/modules/Wpbox/Providers/../Resources/views/campaigns/infoboxes.blade.php ENDPATH**/ ?>