@extends('layouts.app', ['title' => __('Pages')])

@section('content')
    <div class="header pb-8 pt-5 pt-md-8">
        <div class="container-fluid">
            <div class="header-body">
                <h1 class="mb-3 mt--3">💰 {{__('Recharge Credit')}}</h1>
              <div class="row align-items-center pt-2">
              </div>
            </div>
        </div>
    </div>

    <div class="container-fluid mt--7">
        <div class="row">
            <div class="col">
                <div class="card shadow">
                    <div class="card-header border-0">
                        <div class="row align-items-center">
                            <div class="col-8">
                                
                            </div>
                            <div class="col-4 text-right">
                                <a href="{{ route('plans.create') }}" class="btn btn-sm btn-primary">{{ __('Add Credits') }}</a>
                            </div>
                        </div>
                    </div>

                    <div class="col-12">
                        @include('partials.flash')
                    </div>
                    
                    
                    @if(count($credits) > 0)
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th style="width: 10%">{{ __('Id') }}</th>
                                <th style="width: 15%">{{ __('Credits') }}</th>
                                <th style="width: 25%">{{ __('Company') }}</th>
                                <th style="width: 25%">{{ __('Expired On') }}</th>
                                <th style="width: 15%">{{ __('Action') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($credits as $credit)
                                <tr>
                                    <td>{{ $credit['id'] }}</td>
                                    <td>{{ $credit['credit_amount'] }}</td>
                                    <td>{{ $credit['company']['name'] }}</td>
                                    <td>{{ $credit['expiration_date'] }}</td>
                                    
                                    <td>
                                        <input type="button" name="{{ $credit['id'] }}_credit" class="btn btn-sm btn-success" value="{{ $credit['credit-amount'] == -1 ? 'Not Authorized' : 'Recharge Credit' }}" style="{{ $credit['id'] == -1 ? 'display: none;' : '' }}">
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                    @endif
                    
                    
                    <div class="card-footer py-4">
                        @if(count($credits))
                            <nav class="d-flex justify-content-end" aria-label="...">
                                
                            </nav>
                        @else
                            <h4>{{ __('You don`t have any plans') }} ...</h4>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
