<?php $__env->startSection('head'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<?php echo $__env->make('companies.partials.modals', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<div class="header  pb-8 pt-5 pt-md-8">
    <div class="container-fluid">
        <div class="header-body">
            <?php if($isBot): ?>
                <h1 class="mb-3 mt--3">🤖 <?php echo e(__('Create new template bot')); ?></h1>
            <?php elseif($isAPI): ?>
                <h1 class="mb-3 mt--3">🔌 <?php echo e(__('Create new API campaign')); ?></h1>
            <?php elseif($isReminder): ?>
                <h1 class="mb-3 mt--3">⏰ <?php echo e(__('Create new reminder')); ?></h1>
            <?php else: ?>
                <h1 class="mb-3 mt--3">📢 <?php echo e(__('Send new campaign')); ?></h1>
            <?php endif; ?>
            <div class="row align-items-center pt-2">
            </div>
        </div>
    </div>
</div>

<form method="POST" action="<?php echo e(route('campaigns.store')); ?>" id="campign" enctype="multipart/form-data">
    <?php echo csrf_field(); ?>
<div class="container-fluid mt--7" id="campign_managment">
    <div class="row">
        <!--Main info-->
        <div class="col-xl-4">
            <div class="card shadow">
                <div class="card-header bg-white border-0">
                    <div class="row align-items-center">
                        <div class="col-8">
                            <?php if($isBot): ?>
                                <h3 class="mb-0"><?php echo e(__('Template bot')); ?></h3>
                            <?php elseif($isAPI): ?>
                                <h3 class="mb-0"><?php echo e(__('API campaign')); ?></h3>
                            <?php elseif($isReminder): ?>
                                <h3 class="mb-0"><?php echo e(__('Reminder')); ?></h3>
                            <?php else: ?>
                                <h3 class="mb-0"><?php echo e(__('Campaign')); ?></h3>
                            <?php endif; ?>
                            
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <?php echo $__env->make('wpbox::campaigns.new.campaign', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
            </div>
        </div>

        <?php if(isset($_GET['template_id'])): ?>
            <!--Variables-->
            <div class="col-xl-4">
                <div class="card shadow">
                    <div class="card-header bg-white border-0">
                        <div class="row align-items-center">
                            <div class="col-8">
                                <h3 class="mb-0"><?php echo e(__('Variables')); ?></h3>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <?php echo $__env->make('wpbox::campaigns.new.variables', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                </div>
            </div>

            <!--Preview and send-->
            <div class="col-xl-4">
                <div class="card shadow">
                    <div class="card-header bg-white border-0">
                        <div class="row align-items-center">
                            <div class="col-8">
                                <h3 class="mb-0"><?php echo e(__('Preview')); ?></h3>
                            </div>
                        </div>
                    </div>
                    <?php echo $__env->make('wpbox::campaigns.new.preview', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>

                <div class="card shadow mt-4">
                    <div class="card-header bg-white border-0">
                        <div class="row align-items-center">
                            <div class="col-8">
                                <?php if($isBot): ?>
                                    <h3 class="mb-0"><?php echo e(__('Save bot')); ?></h3>
                                <?php elseif($isAPI): ?>
                                    <h3 class="mb-0"><?php echo e(__('Save API campaign')); ?></h3>
                                <?php elseif($isReminder): ?>
                                    <h3 class="mb-0"><?php echo e(__('Save reminder campaign')); ?></h3>
                                <?php else: ?>
                                    <h3 class="mb-0"><?php echo e(__('Send campaign')); ?></h3>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <?php if(!isset($_GET['contact_id'])): ?>
                            <?php if($isBot): ?>
                                <p><?php echo e(__('This message will be sent to the contact once the trigger rule is met in the message sent by the contact.')); ?></p>  
                            <?php elseif($isAPI): ?>
                                <p><?php echo e(__('This message will be sent once API with campaign ID called')); ?></p>
                            <?php elseif($isReminder): ?>
                                <p><?php echo e(__('This message will be sent based on the reminder settings.')); ?></p>
                            <?php else: ?>
                                <?php if($selectedContacts!=""): ?>
                                    <?php if($selectedContacts==1): ?>
                                        <p><?php echo e(__('Send to')); ?>:<?php echo e($selectedContacts); ?> <?php echo e(__('contact')); ?></p>
                                    <?php else: ?>
                                        <p><?php echo e(__('Send to')); ?>:<?php echo e($selectedContacts); ?> <?php echo e(__('contacts')); ?></p>
                                    <?php endif; ?>
                                <?php endif; ?> 
                            <?php endif; ?>
                        <?php endif; ?>
                        
                        <?php if($isBot): ?>
                            <button  class="btn btn-success mt-4" type="submit"><?php echo e(__('Save bot')); ?></button>
                        <?php elseif($isAPI): ?>
                            <button  class="btn btn-success mt-4" type="submit"><?php echo e(__('Save API Campaign')); ?></button>
                        <?php elseif($isReminder): ?>
                            <button  class="btn btn-success mt-4" type="submit"><?php echo e(__('Save Reminder Campaign')); ?></button>
                        <?php else: ?>
                            <?php if(!isset($_GET['contact_id'])&&$selectedContacts>0): ?>
                                <button  class="btn btn-success mt-4" type="submit"><?php echo e(__('Send campaign')); ?></button>
                            <?php elseif(isset($_GET['contact_id'])): ?>
                                <button  class="btn btn-success mt-4" type="submit"><?php echo e(__('Send campaign')); ?></button>
                            <?php endif; ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    </div>
</div>
</form>
<?php $__env->stopSection(); ?>


<script>

    var vuec=null;
    var component=<?php echo json_encode($selectedTemplateComponents, 15, 512) ?>;
    

    function submitJustCampign(){
        event.preventDefault();
    
    
        // Get form data
        const formData = new FormData(document.getElementById("campign"));
    
        // Build URL with GET parameters
        const url = window.location.protocol + "//" + window.location.host + window.location.pathname + "?" + new URLSearchParams(formData).toString();
    
        // Redirect to the URL (or use for AJAX request)
        window.location.href = url;
    
       
    }

    
    
    window.onload = function () {

        $(".form-control").on("input", function() {
            alert("Change");
        });

     
        $("#paramvalues[header][1]").on("input", function() {
            alert($(this).val()); 
        });
                
        vuec = new Vue({
            el: '#campign_managment',
            data: {
                body_1:"",
                body_2:"",
                body_3:"",
                body_4:"",
                body_5:"",
                body_6:"",
                body_7:"",
                body_8:"",
                body_9:"",
                header_1:"",
                imagePreview:null,
                videoPreview:null
            },
            methods: {
                setPreviewValue: function () {

                   
                    this.body_1=this.$refs['paramvalues[body][1]']?this.$refs['paramvalues[body][1]'].value:"";
                    this.body_2=this.$refs['paramvalues[body][2]']?this.$refs['paramvalues[body][2]'].value:"";
                    this.body_3=this.$refs['paramvalues[body][3]']?this.$refs['paramvalues[body][3]'].value:"";
                    this.body_4=this.$refs['paramvalues[body][4]']?this.$refs['paramvalues[body][4]'].value:"";
                    this.body_5=this.$refs['paramvalues[body][5]']?this.$refs['paramvalues[body][5]'].value:"";
                    this.body_6=this.$refs['paramvalues[body][6]']?this.$refs['paramvalues[body][6]'].value:"";
                    this.body_7=this.$refs['paramvalues[body][7]']?this.$refs['paramvalues[body][7]'].value:"";
                    this.body_8=this.$refs['paramvalues[body][8]']?this.$refs['paramvalues[body][8]'].value:"";
                    this.body_9=this.$refs['paramvalues[body][9]']?this.$refs['paramvalues[body][9]'].value:"";
                    this.header_1=this.$refs['paramvalues[header][1]']?this.$refs['paramvalues[header][1]'].value:"";
                
                },
                handleImageUpload(event) {


                    
                    const selectedFile = event.target.files[0];

                    if (selectedFile) {
                       
                        const reader = new FileReader();

                        reader.onload = () => {
                            this.imagePreview = reader.result;
                        };

                        reader.readAsDataURL(selectedFile);
                    } else {
                        // Handle the case when no file is selected or an error occurs.
                        this.imagePreview = "default-image.jpg";
                    }
                },
                handleImageUpload(event) {


                    
                    const selectedFile = event.target.files[0];

                    if (selectedFile) {
                       
                        const reader = new FileReader();

                        reader.onload = () => {
                            this.imagePreview = reader.result;
                        };

                        reader.readAsDataURL(selectedFile);
                    } else {
                        // Handle the case when no file is selected or an error occurs.
                        this.imagePreview = "default-image.jpg";
                    }
                },
                handleVideoUpload(event) {
                    const selectedFile = event.target.files[0];

                    if (selectedFile) {
                    
                        const reader = new FileReader();

                        reader.onload = () => {
                            this.videoPreview = reader.result;
                        };

                        reader.readAsDataURL(selectedFile);
                    } else {
                        // Handle the case when no file is selected or an error occurs.
                        this.videoPreview = "default-image.jpg";
                    }
                },

            }
         });
         vuec.setPreviewValue();

    }
    
</script>

<?php echo $__env->make('layouts.app', ['title' => __('Send new campaign')], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/aspailtd/public_html/dps.aspai.ltd/modules/Wpbox/Providers/../Resources/views/campaigns/create.blade.php ENDPATH**/ ?>