<?php $__env->startSection('content'); ?>
    <div class="header pb-8 pt-5 pt-md-8">
        <div class="container-fluid">
            <div class="header-body">
                <h1 class="mb-3 mt--3">💰 <?php echo e(__('Credits')); ?></h1>
                <div class="row align-items-center pt-2">
                </div>
            </div>
        </div>
    </div>

    <div class="container-fluid mt--7">
        <div class="row">
            <div class="col">
                <div class="card shadow">
                    <div class="card-header border-0">
                        <div class="row align-items-center">
                            <div class="col-8">
                                <h3 class="mb-0"><?php echo e(__('Costs per action')); ?></h3>
                            </div>
                            <div class="col-4 text-right">
                                
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <form method="POST" action="<?php echo e(route('credits.costs')); ?>">
                            <?php echo csrf_field(); ?>
                            <?php if(count($actions) == 0): ?>
                                <div class="text-center">
                                    <p><?php echo e(__('There are no modules with credit costs defined.')); ?></p>
                                </div>
                            <?php endif; ?>

                            <?php if(count($actions) > 0): ?>
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th style="width: 50%"><?php echo e(__('Action')); ?></th>
                                            <th style="width: 25%"><?php echo e(__('Type')); ?></th>
                                            <th style="width: 25%"><?php echo e(__('Cost in credits')); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $actions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $action): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($action['name']); ?></td>
                                                <td>
                                                    <select class="form-control action_type custom-select" name="<?php echo e($action['action']); ?>_type">
                                                        <option value="-1" <?php echo e($action['cost'] == -1 ? 'selected' : ''); ?>>
                                                            <i class="fas fa-chart-line mr-2"></i>
                                                            <?php echo e(__('Usage based')); ?>

                                                        </option>
                                                        <option value="1" <?php echo e($action['cost'] != -1 ? 'selected' : ''); ?>>
                                                            <i class="fas fa-lock mr-2"></i>
                                                            <?php echo e(__('Fixed amount')); ?>

                                                        </option>
                                                    </select>
                                                </td>
                                                <td>
                                                    <input type="number" name="<?php echo e($action['action']); ?>_cost" class="form-control" value="<?php echo e($action['cost'] == -1 ? '' : $action['cost']); ?>" style="<?php echo e($action['cost'] == -1 ? 'display: none;' : ''); ?>">
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                                
                                <div class="text-right mt-4">
                                    <button type="submit" class="btn btn-primary">
                                        <i class="fas fa-save mr-2"></i><?php echo e(__('Save Changes')); ?>

                                    </button>
                                </div>
                            <?php endif; ?>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>

    <script type="text/javascript">
            $(document).ready(function() {
                $('select.action_type').on('change', function() {
                if($(this).val() == "-1"){
                    $(this).parent().parent().find('input').hide();
                }else{
                    $(this).parent().parent().find('input').show();
                }
                });
            });

    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', ['title' => __('Credits')], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/aspailtd/public_html/dps.aspai.ltd/resources/views/credits/costs/costs.blade.php ENDPATH**/ ?>